#ifndef TREE_NODE_HPP
#define TREE_NODE_HPP

#include "Body.hpp"
#include "Box.hpp"
#include "Tree.hpp"
#include "BarnesHutTree.hpp"
#include <cstdlib>
#include <vector>

namespace nbody {
	//class for storing node information
	class Node {
		friend class Tree;
		friend class BarnesHutTree;
	protected:
		Box bb;
		std::vector<Body> bodies;
		Node* prev;
		Node* next;
		Node* nextSibling;
		Node* prevSibling;
		Node* parent;
		Node* afterSubtree;
		bool leaf;
		Tree* tree;
		Body representative;
	public:
		Node(Tree* tree);
		virtual bool isSplitable() const;
		virtual void extendBBforBodies();
		virtual void extendBBtoCube();
		virtual Box getBB() const;
		virtual void setBB(const Box& bb);
		virtual std::vector<Body> getBodies() const;
		virtual void insertBefore(Node* node);
		virtual void insertAfter(Node* node);
		virtual void unlink();
		virtual void update();
		virtual double getL() const;
		virtual bool isCorrect() const;
		virtual void print(int parallelId) const;
		virtual bool sufficientForBody(const Body& body) const;
		virtual bool sufficientForBox(const Box& box) const;
		virtual void setBodies(const std::vector<Body>& bodies); //TODO(steinret): && optimization
		virtual void extractLocalBodiesTo(std::vector<Body>& bodies);
	};
}

#endif
