#include <string>
#include <iostream>
#include "Simulation.hpp"

namespace nbody {
	void Simulation::clearBodies() {
		bodies.clear();
	}

	std::vector<Body> Simulation::getBodies() const {
		return bodies;
	}

	bool Simulation::readInputData(const std::string& filename) {
		if (getProcessId() == 0) {
			bodies = dubinskiParse(filename);
			if (bodies.empty()) {
				return false;
			}
		}
		return true;
	}

	Tree* Simulation::getTree() {
		return tree;
	}

} // namespace nbody
