#ifndef TREE_HPP
#define TREE_HPP

#include <cstdlib>
#include <string>
#include <vector>

#include "Body.hpp"
#include "Box.hpp"
#include "Node.hpp"

namespace nbody {
	class Simulation;

	//superclass for Barnes-Hut tree
	class Tree {
		friend class Node;
	protected:
		Node* nodes;
		std::size_t maxLeafBodies{ 0 };
		std::size_t parallelId{ 0 };
		Simulation* simulation{ nullptr };
	public:
		Tree(std::size_t parallelId);
		virtual ~Tree();
		virtual void setSimulation(Simulation* simulation_);
		virtual void clean();
		virtual void build(const std::vector<Body>& bodies) = 0;
		virtual void build(const std::vector<Body>& bodies, const Box& domain) = 0;
		virtual std::size_t numberOfChildren() const = 0;
		virtual std::size_t numberOfNodes() const;
		virtual bool isCorrect() const;
		virtual void accumulateForceOnto(Body& body);
		virtual void computeForces();
		virtual std::vector<Body> extractLocalBodies();
		virtual std::vector<Body> copyRefinements(const Box& domain) const;
		virtual void rebuild(const Box& domain);
		virtual void rebuild(const Box& domain, const std::vector<Body>& bodies);
		virtual void rebuild();
		virtual Box getRootBB() const;
		virtual void print(std::size_t parallelId) const;
		virtual Box advance();
		virtual Box getLocalBB() const;
	private:
		class NodesView {
			Tree* tree_;
		public:
			NodesView(Tree* tree);
			Node::NodeIterator begin();
			Node::NodeIterator end();
			Node::NodeIterator begin() const;
			Node::NodeIterator end() const;
		};
		NodesView nodesView;
	};
} // namespace nbody

#endif
