#ifndef SIMULATION_HPP
#define SIMULATION_HPP

#include <vector>

#include "BarnesHutTree.hpp"
#include "Body.hpp"

namespace nbody {
	//simulation superclass
	class Simulation {
	protected:
		int parallelSize{ -1 };
		int parallelRank{ -1 };
		bool correctState{ false };
		std::vector<Body> bodies;
		BarnesHutTree* tree{ nullptr };
	public:
		virtual void clearBodies();
		virtual std::vector<Body> getBodies() const;
		virtual std::size_t getNumberOfProcesses() const = 0;
		virtual std::size_t getProcessId() const = 0;
		virtual bool readInputData(const std::string& filename);
		virtual Tree* getTree();
		virtual void runStep() = 0;
	};
} // namespace nbody

#endif
