#ifndef BOX_HPP
#define BOX_HPP

#include <vector>
#include <array>
#include <Body.hpp>

namespace nbody {
	typedef struct _Box {
		std::array<double, 3> min;
		std::array<double, 3> max;
	} Box;

	void initBox(Box& box);
	void extendToCube(Box& box);
	void extendForBodies(Box& box, std::vector<Body> bodies);
	std::vector<Body> extractBodies(Box box, std::vector<Body>& bodies);
	std::vector<Body> copyBodies(Box box, std::vector<Body> bodies);
	bool isContained(Body body, Box box);
	bool isContained(Box inner, Box outer);
	double volume(Box box);
	double maxSidelength(Box box);
	bool isCorrectBox(Box box);
	bool isValid(Box box);
	void printBB(int parallelId, Box box);
	bool overlapsSphere(Box box, double* sphereCenter, double sphereRadius);
	double distanceToPosition(Box box, double* position);
	double distanceToBox(Box box1, Box box2);
	std::vector<Box> octreeSplit(Box box);
	std::vector<Box> splitLongestSide(Box box);
	bool contained(Box box, std::array<double, 3> position);
	void extend(Box& box, Box extender);
	void extend(Box& box, Body extender);
}

#endif
