#include <BarnesHutTree.hpp>
#include <MpiSimulation.hpp>
#include <iostream>
#include <mpi.h>
#include <cstdlib>
#include <Tree.hpp>

using namespace nbody;

int main(int argc, char* argv[]) {
	MPI_Init(&argc, &argv);
	if (argc < 2) {
		MPI_Finalize();
		std::cerr << "need input file parameter\n";
		return -1;
	}
	MpiSimulation simulation;
	int rank;

	MPI_Comm_rank(MPI_COMM_WORLD, &rank);
	//initialize and load particles
	simulation.initialize(std::string(argv[1]));
	//initial particle and domain distribution
	simulation.distributeBodies();
	simulation.distributeDomains();
	simulation.buildTree();
	for (int i = 0; i < 3; i++) {
		//local tree is built and correct domains are distributed
		simulation.runStep();
	}
	simulation.cleanup();
	MPI_Finalize();
	return 0;
}
