#ifndef SIMULATION_HPP
#define SIMULATION_HPP

#include <vector>
#include <Body.hpp>
#include <BarnesHutTree.hpp>

namespace nbody {
	//simulation superclass
	class Simulation {
	protected:
		int parallelSize;
		int parallelRank;
		int correctState;
		std::vector<Body> bodies;
		BarnesHutTree* tree;
	public:
		Simulation();
		virtual ~Simulation();
		virtual void initialize(std::string inputFile) = 0;
		virtual void cleanup() = 0;
		virtual void clearBodies();
		virtual void addBodies(std::vector<Body> bodies);
		virtual std::vector<Body> getBodies();
		virtual int getNumberOfProcesses() = 0;
		virtual int getProcessId() = 0;
		virtual bool readInputData(std::string filename);
		virtual Tree* getTree();
		virtual void runStep() = 0;
	};
}

#endif
