#ifndef BODY_HPP
#define BODY_HPP

#include <vector>
#include <string>
#include <array>

namespace nbody {
	static const double timestep = 1.0;

	struct Derivative {
		std::array<double, 3> dx{};
		std::array<double, 3> dv{};
	};

	struct Body { //TODO(steinret): figure out, why this is faster without initialization
		std::size_t id{};
		std::array<double, 3> position{};
		std::array<double, 3> velocity{};
		std::array<double, 3> acceleration{};
		double mass{};
		bool refinement{};

		void resetAcceleration();
		Derivative evaluate(double dt, const Derivative& d) const;
		void integrate();
		void accumulateForceOntoBody(const Body& from);
		bool isValid() const;
		void print(std::size_t parallelId) const;
	};

	void printBodies(std::size_t parallelId, const std::vector<Body>& bodies);
	bool valid(const std::vector<Body>& bodies);
	std::vector<Body> dubinskiParse(const std::string& filename);
} // namespace nbody

#endif
