#ifndef MPI_SIMULATION_HPP
#define MPI_SIMULATION_HPP


#include <mpi.h>
#include <Simulation.hpp>
#include <BarnesHutTree.hpp>
#include <cstddef>
#include <vector>

namespace nbody {
	struct SendStore {
		Body* bodies;
		MPI_Request request;
		std::size_t size;
	};

	//MPI simulation
	class MpiSimulation : public Simulation {
	protected:
		MPI_Datatype bodyType;
		MPI_Datatype boxType;
		std::vector<Box> domains;
		Box overallDomain;
		std::vector<SendStore> sendStores;

		virtual SendStore* availableSendStore(std::size_t numElems);
		virtual void send(std::vector<Body> bodies, int target);
		virtual int recv(std::vector<Body>& bodies, int source);
	public:
		MpiSimulation(const std::string& inputFile);
		virtual ~MpiSimulation();
		virtual std::size_t getNumberOfProcesses() const;
		virtual std::size_t getProcessId() const;
		virtual bool stateCorrect();
		virtual void distributeBodies();
		virtual void distributeDomains(const std::vector<Body>& localBodies);
		virtual void distributeDomains(const Box& localDomain);
		virtual void distributeDomains();
		virtual void distributeLETs();
		virtual void rebuildTree();
		virtual void buildTree();
		virtual void runStep();
		virtual MPI_Datatype* getDatatype();
	};
} // namespace nbody

#endif

