#include <string>
#include <iostream>
#include "Simulation.hpp"

namespace nbody {
	Simulation::Simulation() {
		this->parallelRank = -1;
		this->parallelSize = -1;
		this->correctState = false;
		this->tree = nullptr;
	}

	void Simulation::clearBodies() {
		this->bodies.clear();
	}

	std::vector<Body> Simulation::getBodies() const {
		return this->bodies;
	}

	bool Simulation::readInputData(const std::string& filename) {
		if (this->getProcessId() == 0) {
			this->bodies = dubinskiParse(filename);
			if (this->bodies.empty()) {
				return false;
			}
		}
		return true;
	}

	Tree* Simulation::getTree() {
		return this->tree;
	}

} // namespace nbody
