#ifndef BARNES_HUT_TREE_HPP
#define BARNES_HUT_TREE_HPP

#include "Tree.hpp"
#include "Box.hpp"

namespace nbody {
	class Node;

	class BarnesHutTree : public Tree {
	protected:
		static std::vector<Box> splitBB(const Node* node);
		static bool splitNode(Node* current);
		virtual void update();
		virtual void init(const std::vector<Body>& bodies, const Box& domain);
		static void split(Node* current);
	public:
		BarnesHutTree(std::size_t parallelId);
		virtual void build(const std::vector<Body>& bodies);
		virtual void build(const std::vector<Body>& bodies, const Box& domain);
		virtual void mergeLET(const std::vector<Body>& bodies);
		virtual std::size_t numberOfChildren() const;
		static void splitSubtree(Node* root);
	};
} // namespace nbody

#endif
