#include <string>
#include <iostream>
#include "Simulation.hpp"

namespace nbody {
	Simulation::Simulation() {
		this->parallelRank = -1;
		this->parallelSize = -1;
		this->correctState = 0;
		this->tree = NULL;
	}

	Simulation::~Simulation() {
	}

	void Simulation::clearBodies() {
		this->bodies.clear();
	}

	void Simulation::addBodies(const std::vector<Body>& bodies) {
		this->bodies.insert(std::end(this->bodies), std::begin(bodies), std::end(bodies));
	}

	std::vector<Body> Simulation::getBodies() const {
		return this->bodies;
	}

	bool Simulation::readInputData(const std::string& filename) {
		if (this->getProcessId() == 0) {
			this->bodies = dubinskiParse(filename);
			if (this->bodies.empty()) {
				return false;
			}
		}
		return true;
	}

	Tree* Simulation::getTree() {
		return this->tree;
	}

}
