#include <BarnesHutTree.hpp>
#include <MpiSimulation.hpp>
#include <iostream>
#include <mpi.h>
#include <Tree.hpp>

int main(int argc, char* argv[]) {
	MPI_Init(&argc, &argv);
	{
		if (argc < 2) {
			MPI_Finalize();
			std::cerr << "need input file parameter\n";
			return -1;
		}
		//initialize and load particles
		nbody::MpiSimulation simulation{ std::string(argv[1]) };

		//initial particle and domain distribution
		simulation.distributeBodies();
		simulation.distributeDomains();
		simulation.buildTree();
		for (std::size_t i = 0; i < 3; i++) {
			//local tree is built and correct domains are distributed
			simulation.runStep();
		}
	}
	MPI_Finalize();
	return 0;
}
