#ifndef BODY_HPP
#define BODY_HPP

#include <vector>
#include <string>
#include <array>

namespace nbody {
	static const double timestep = 1.0;

	typedef struct DerivativeStruct {
		std::array<double, 3> dx;
		std::array<double, 3> dv;
	} Derivative;

	typedef struct BodyStruct {
		unsigned long id;
		std::array<double, 3> position;
		std::array<double, 3> velocity;
		std::array<double, 3> acceleration;
		double mass;
		int refinement;
	} Body;

	void resetAcceleration(Body& body);
	Derivative evaluate(Body body, double dt, Derivative d);
	void integrate(Body& body);
	void accumulateForceOntoBody(Body& to, Body from);
	bool validBody(Body body);
	void printBody(int parallelId, Body body);
	void printBodies(int parallelId, std::vector<Body> bodies);
	bool valid(std::vector<Body> bodies);
	std::vector<Body> dubinskiParse(std::string filename);
}

#endif
