#ifndef BODY_HPP
#define BODY_HPP

#include <vector>
#include <string>
#include <array>

namespace nbody {
	static const double timestep = 1.0;

	struct Derivative {
		std::array<double, 3> dx;
		std::array<double, 3> dv;
	};

	struct Body {
		unsigned long id;
		std::array<double, 3> position;
		std::array<double, 3> velocity;
		std::array<double, 3> acceleration;
		double mass;
		int refinement;

		void resetAcceleration();
		Derivative evaluate(double dt, const Derivative& d) const;
		void integrate();
		void accumulateForceOntoBody(const Body& from);
		bool isValid() const;
		void print(int parallelId) const;
	};

	void printBodies(int parallelId, const std::vector<Body>& bodies);
	bool valid(const std::vector<Body>& bodies);
	std::vector<Body> dubinskiParse(const std::string& filename);
}

#endif
