#ifndef SIMULATION_HPP
#define SIMULATION_HPP

#include <vector>
#include <Body.hpp>
#include <BarnesHutTree.hpp>

namespace nbody {
	//simulation superclass
	class Simulation {
	protected:
		int parallelSize;
		int parallelRank;
		int correctState;
		std::vector<Body> bodies;
		BarnesHutTree* tree;
	public:
		Simulation();
		virtual void clearBodies();
		virtual void addBodies(const std::vector<Body>& bodies); //TODO(steinret) && opt
		virtual std::vector<Body> getBodies() const;
		virtual int getNumberOfProcesses() const = 0;
		virtual int getProcessId() const = 0;
		virtual bool readInputData(const std::string& filename);
		virtual Tree* getTree();
		virtual void runStep() = 0;
	};
}

#endif
