#ifndef BODY_HPP
#define BODY_HPP

#include <vector>
#include <string>
#include <array>

namespace nbody {
	static const double timestep = 1.0;

	typedef struct DerivativeStruct {
		std::array<double, 3> dx;
		std::array<double, 3> dv;
	} Derivative;

	typedef struct BodyStruct { //TODO(steinret): c++ structs
		unsigned long id;
		std::array<double, 3> position;
		std::array<double, 3> velocity;
		std::array<double, 3> acceleration;
		double mass;
		int refinement;
	} Body;

	void resetAcceleration(Body& body);
	Derivative evaluate(const Body& body, double dt, const Derivative& d);
	void integrate(Body& body);
	void accumulateForceOntoBody(Body& to, const Body& from);
	bool validBody(const Body& body);
	void printBody(int parallelId, const Body& body);
	void printBodies(int parallelId, const std::vector<Body>& bodies);
	bool valid(const std::vector<Body>& bodies);
	std::vector<Body> dubinskiParse(const std::string& filename);
}

#endif
