#ifndef BOX_HPP
#define BOX_HPP

#include <vector>
#include <array>
#include <Body.hpp>

namespace nbody {
	typedef struct _Box {
		std::array<double, 3> min;
		std::array<double, 3> max;
	} Box;

	void initBox(Box& box);
	void extendToCube(Box& box);
	void extendForBodies(Box& box, const std::vector<Body>& bodies);
	std::vector<Body> extractBodies(const Box& box, std::vector<Body>& bodies);
	std::vector<Body> copyBodies(const Box& box, const std::vector<Body>& bodies);
	bool isContained(const Body& body, const Box& box);
	bool isContained(const Box& inner, const Box& outer);
	double volume(const Box& box);
	double maxSidelength(const Box& box);
	bool isCorrectBox(const Box& box);
	bool isValid(const Box& box);
	void printBB(int parallelId, const Box& box);
	bool overlapsSphere(const Box& box, const double* sphereCenter, double sphereRadius); //TODO(steinret): double* srsly?
	double distanceToPosition(const Box& box, const double* position);
	double distanceToBox(const Box& box1, const Box& box2);
	std::vector<Box> octreeSplit(const Box& box);
	std::vector<Box> splitLongestSide(const Box& box);
	bool contained(const Box& box, const std::array<double, 3>& position);
	void extend(Box& box, const Box& extender);
	void extend(Box& box, const Body& extender);
}

#endif
