#pragma once

#include <algorithm>
#include <array>
#include <boost/program_options.hpp>
#include <cstddef>
#include <istream>
#include <string>
#include <tuple>

#include "MpiEnvironment.hpp"
#include "Util.hpp"

enum class CommunicationMode {
	Collective, //
	P2P         //
};

struct Configuration {

	Size Grid{};
	std::string InputFilePath;
	std::string OutputFilePath;
	std::size_t Generations{1000};
	CommunicationMode CommMode{CommunicationMode::Collective};

	static auto parseArgs(int argc, char* argv[], const MpiEnvironment& env)
	    -> Configuration;
};
