#pragma once

#include <cstddef>
#include <string>

#include "gsl/gsl"

#include "MpiEnvironment.hpp"
#include "MpiSubarray.hpp"
#include "State.hpp"
#include "Util.hpp"

struct HeaderInfo {
	Size GlobalSize;
	std::size_t HeaderLength;
};

struct FileIO {
	static HeaderInfo ReadHeader(const std::string& path);

	static void WriteHeader(const HeaderInfo& header, const std::string& path,
	                        const MpiEnvironment& env);

	static Size GetTileSize(Size globalSize, Size gridSize);

	// helper class to share commonly used data for reading and writing
	class Tile {
		static constexpr std::size_t LF = 1; // linefeed chars
		const std::string& _path;
		const std::size_t _headerLength;
		const Size _srcSize;
		const Size _gridSize;
		const std::size_t _rank;
		gsl::span<State> _buf;

		const Size _tileSize;
		const std::size_t _tileX;
		const std::size_t _tileY;
		const MpiSubarray _tileType;
		const MpiSubarray _bufType;
		const std::size_t _displ;

	  public:
		Tile(const std::string& path, HeaderInfo header, Size gridSize,
		     std::size_t rank, gsl::span<State> buf);

		void Read();
		void Write() const;
	};
};
