#include <cassert>
#include <chrono>
#include <cstdlib>
#include <fstream>
#include <iostream>
#include <string>
#include <thread>
#include <vector>

#include "Configuration.hpp"
#include "MpiEnvironment.hpp"
#include "MpiWireworld.hpp"

using namespace std::string_literals;

int main(int argc, char* argv[]) {
	static constexpr auto DebugRank = 0;
	const auto& starttime = std::chrono::system_clock::now();

	MpiEnvironment env(argc, argv);
	const auto& cfg = Configuration::parseArgs(argc, argv, env);

	MpiWireworld ww(env, cfg);

	for (std::size_t i{0}; i < cfg.Generations; ++i) {
		ww.simulateStep();

		if ((i % 1000) == 0 && env.isMaster()) { // show progress
			std::cout << "iteration:" << i << '\n';
		}
	}
	if (!cfg.OutputFilePath.empty()) { ww.write(); }

	if (env.isMaster()) {
		std::cout
		    << "Execution time:"
		    << std::chrono::duration<double>{std::chrono::system_clock::now() -
		                                     starttime}
		           .count()
		    << "s\n";
	}
	return EXIT_SUCCESS;
}