#ifndef _CELLS_H_
#define _CELLS_H_

#include <stddef.h>
#include <mpi.h>

typedef struct
{
   size_t n_neighbors;
   MPI_Comm graph_comm;
   
   MPI_Datatype send_types[8];
   MPI_Datatype recv_types[8];

   MPI_Datatype io_type;
} transfer_t;

typedef struct
{
   size_t global_size[2];
   size_t local_size[2];
   size_t local_start[2];

   char *cells_prev;
   char *cells_next;

   transfer_t transfer;
} world_t;

void world_init(world_t *world, MPI_Comm cart_comm, size_t *global_size);

size_t world_get_storage_size(const world_t *world);

void world_free(world_t *world);

#endif

