# Author: Alexandre Boucaud <aboucaud@lal.in2p3.fr>
# License: BSD 3 clause

from __future__ import print_function

import os
import sys

try:
    from urllib.request import urlretrieve
except ImportError:
    from urllib import urlretrieve

URLBASE = 'https://storage.ramp.studio/astrophd_tutorial/{}'
DATA = [
    'data_prace_train.npy',
    'data_prace_test.npy',
    'labels_prace_train.npy',
    'labels_prace_test.npy'
]


def main(path=None, output_dir='data'):
    path = path or ""
    fullpath = os.path.join(path, output_dir)
    filenames = DATA

    urls = [URLBASE.format(filename) for filename in filenames]

    if not os.path.exists(fullpath):
        os.mkdir(fullpath)

    for url, filename in zip(urls, filenames):
        output_file = os.path.join(fullpath, filename.replace('_prace', ''))

        if os.path.exists(output_file):
            print("{} already downloaded".format(filename))
            continue

        print("Downloading from {} ...".format(url))
        urlretrieve(url, filename=output_file)
        print("=> File saved as {}".format(output_file))


if __name__ == '__main__':
    try:
        path = sys.argv[1]
        main(path=path)
    except IndexError:
        main()
