!===============================================================================
!
! BQCD -- Berlin Quantum ChromoDynamics program
!
! Author: Hinnerk Stueben <stueben@zib.de>
!
! Copyright (C) 2003, Hinnerk Stueben, Zuse-Institut Berlin
!
!-------------------------------------------------------------------------------
!
! D3_switch.F90 - switch layer for arbitrary choice of "gamma_index"
!
!-------------------------------------------------------------------------------
# include "defs.h"

#ifdef INIT
# define THE_NAME(a) STRCAT3(NAME, a, _0)
#else
# define THE_NAME(a) STRCAT(NAME, a)
#endif

! NAME = d or d_dag
!-------------------------------------------------------------------------------
subroutine THE_NAME(_switch)(e, o, out, in, u, i1, i2, mu)

  use module_lattice
  use module_nn
  use module_vol
  implicit none
 
  integer :: e, o
  SPINCOL_FIELD :: out, in
  GAUGE_FIELD :: u
  integer :: i1, i2, mu

  select case (gamma_index(mu))
     case (1)
        call THE_NAME(_xf)(out, in, u(1, 1, 1, e, 1), &
                                    u(1, 1, 1, o, 1), &
                                         nn(1, e, 1, FWD), &
                                         nn(1, e, 1, BWD), i1, i2)
     case (2)
        call THE_NAME(_yf)(out, in, u(1, 1, 1, e, 2), & 
                                    u(1, 1, 1, o, 2), &
                                         nn(1, e, 2, FWD), &
                                         nn(1, e, 2, BWD), i1, i2)
     case (3)
        call THE_NAME(_zf)(out, in, u(1, 1, 1, e, 3), &
                                    u(1, 1, 1, o, 3), &
                                         nn(1, e, 3, FWD), &
                                         nn(1, e, 3, BWD), i1, i2)
     case (4)
        call THE_NAME(_t )(out, in, u(1, 1, 1, e, 4), &
                                    u(1, 1, 1, o, 4), &
                                         nn(1, e, 4, FWD), &
                                         nn(1, e, 4, BWD), i1, i2)
  end select
end
!===============================================================================
