!===============================================================================
!
! BQCD -- Berlin Quantum ChromoDynamics program
!
! Author: Hinnerk Stueben <stueben@zib.de>
!
! Copyright (C) 2000-2002, Hinnerk Stueben, Zuse-Institut Berlin
!
!-------------------------------------------------------------------------------
!
! h_mult.F90
!
!-------------------------------------------------------------------------------
# include "defs.h"

!-------------------------------------------------------------------------------
subroutine h_mult_a(out, h, in, volh)  ! out := out + i h gamma_5 in

  implicit none
  COMPLEX, dimension (NDIRAC, *) :: out, in
  REAL                           :: h
  integer                        :: volh

  integer :: i

  ! statement function:
  
  COMPLEX :: i_times, c
  i_times(c) = cmplx(-aimag(c), real(c))

  TIMING_START(timing_bin_h_mult_a)

  !$omp parallel do
  do i = 1, NCOL * volh
     out(1, i) = out(1, i) + h * i_times(in(3, i))
     out(2, i) = out(2, i) + h * i_times(in(4, i))
     out(3, i) = out(3, i) + h * i_times(in(1, i))
     out(4, i) = out(4, i) + h * i_times(in(2, i))
  enddo

  TIMING_STOP(timing_bin_h_mult_a)
end

!-------------------------------------------------------------------------------
subroutine h_mult_b(h, x, volh)  ! x := (1 + i h gamma_5) x

  implicit none
  REAL                           :: h
  COMPLEX, dimension (NDIRAC, *) :: x
  integer                        :: volh 

  integer :: i
  COMPLEX :: x1, x2, x3, x4

  ! statement function:
  
  COMPLEX :: i_times, c
  i_times(c) = cmplx(-aimag(c), real(c))


  TIMING_START(timing_bin_h_mult_b)

  !$omp parallel do private(x1, x2, x3, x4)
  do i = 1, NCOL * volh
     x1 = x(1, i)
     x2 = x(2, i)
     x3 = x(3, i)
     x4 = x(4, i)
     
     x(1, i) = x(1, i) + h * i_times(x3)
     x(2, i) = x(2, i) + h * i_times(x4)
     x(3, i) = x(3, i) + h * i_times(x1)
     x(4, i) = x(4, i) + h * i_times(x2)
  enddo

  TIMING_STOP(timing_bin_h_mult_b)
end

!-------------------------------------------------------------------------------
subroutine h_mult_c(out, h, in, volh)  ! out = (1 + i h gamma_5) in

  implicit none
  COMPLEX, dimension (NDIRAC, *) :: out, in
  REAL                           :: h
  integer                        :: volh

  integer :: i

  ! statement function:
  
  COMPLEX :: i_times, c
  i_times(c) = cmplx(-aimag(c), real(c))

  TIMING_START(timing_bin_h_mult_c)

  !$omp parallel do
  do i = 1, NCOL * volh
     out(1, i) = in(1, i) + h * i_times(in(3, i))
     out(2, i) = in(2, i) + h * i_times(in(4, i))
     out(3, i) = in(3, i) + h * i_times(in(1, i))
     out(4, i) = in(4, i) + h * i_times(in(2, i))
  enddo

  TIMING_STOP(timing_bin_h_mult_c)
end

!===============================================================================
