!===============================================================================
!
! BQCD -- Berlin Quantum ChromoDynamics program
!
! Author: Hinnerk Stueben <stueben@zib.de>
!
! Copyright (C) 2003, Hinnerk Stueben, Zuse-Institut Berlin
!
!-------------------------------------------------------------------------------
!
! iteration_count.F90  -  counts iterations in Hasenbusch improvement,
!                         does not work with tempering
!
!-------------------------------------------------------------------------------
module module_iteration_count

  integer, save :: it_f1 = 0  ! iterations in dsf1()
  integer, save :: it_f2 = 0  ! iterations in dsf2()
end

!-----------------------------------------------------------------------------
subroutine iteration_count_f1(iter)
    
  use module_iteration_count
  implicit none
  integer :: iter
  
  it_f1 = it_f1 + iter
end

!-----------------------------------------------------------------------------
subroutine iteration_count_f2(iter)

  use module_iteration_count
  implicit none
  integer :: iter
 
  it_f2 = it_f2 + iter
end

!-----------------------------------------------------------------------------
subroutine iteration_count_write(unit)

  use module_counter
  use module_function_decl
  use module_iteration_count
  use module_switches

  implicit none

  integer, intent(in)     :: unit
  integer, save           :: written = 0 

  character(*), parameter :: key   = "%it"
  character(*), parameter :: fmt_h = "(1x, 2a, a6, 2a16)"
  character(*), parameter :: fmt_b = "(1x, a4, i6, 2i16)"

  if (switches%hasenbusch) then

     if (written == 0 .and. my_pe() == 0) then
        write(unit, fmt_h) "T", key, "traj", "iterations(F1)", "iterations(F2)"
     endif
     
     if (my_pe() == 0) write(unit, fmt_b) key, counter%traj, it_f1, it_f2
 
  endif 
    
  written = written + 1
  it_f1 = 0
  it_f2 = 0
end
!===============================================================================
