#!/bin/bash
echo "==> Choose supercomputer :"
echo "     - occigen"
echo "     - marenostrum "
echo "     - marconi-knl "
echo "     - daint-gpu "
echo "     - daint-cpu-only "
echo "     - davide "
echo "     - juwels"
echo "     - juwels-booster"
echo "     - juwels_2018"
echo "     - irene-skl "
echo "     - irene-knl "
echo "     - dibona "
echo "     - frioul "
echo "     - deepsdv "
echo "     - hazelhen  "
echo "     - vega-gpu"
echo "     - vega-cpu"
echo "     - marconi100  "
echo "     - supermuc-ng "

read machine

export NEX_XI=384 #384 #416 #352 #320 #288 #256 #224 #192 #160 #128 #96 #288
export NPROC_XI=4
source ./env/env_${machine}

Untar(){
    echo "==> Untar "
    #Clone the repository
    cd $install_dir
    git -c http.sslVerify=false clone  https://github.com/geodynamics/specfem3d_globe.git
    code=$?
    if [[  $code != "0" ]]; then
        echo "Git clone failed, try a hard copy:"        
        Copy 
    else
        cd specfem3d_globe/
        git checkout b1d6ba966496f269611eff8c2cf1f22bcdac2bd9	# Checkout of 31 ocotbre 2017 version
        #git checkout v7.0.2	# Checkout v7.0.2, last version : unstable : tested on differents architectures and all simulations failed
    fi
    cd $ueabs_dir
}

Copy(){
    # Copy sources (Edit source_dir if needed)
    source_dir=$HOME/git/specfem3d_globe
    echo "Copy source"
    cp -r $source_dir $install_dir
}

Install(){
    echo "===>  Configure "
    answer=0
    echo "1. small_benchmark_run_to_test_more_complex_Earth : specfem3D_globe native benchmark to validate the behaviour of the code designed to run on 24 MPI process"
    echo "2. Test Case A is designed to run on Tier-1 sized systems (up to around 1,000 x86 cores, or equivalent)"
    echo "3. Test Case B is designed to run on Tier-0 sized systems (up to around 10,000 x86 cores, or equivalent)"
    while true
    do
        echo "===> Choose Test Case : (1, 2, or 3)"
        read answer
        if [[ $answer -eq 1 || $answer -eq 2 || $answer -eq 3 ]]; then break;fi
    done
    if [ $answer = "1" ]; then
	echo "===> small_benchmark_run_to_test_more_complex_Earth"
	cd $install_dir/specfem3d_globe/EXAMPLES/small_benchmark_run_to_test_more_complex_Earth
	sed -i "38a ./configure  --enable-openmp" run_this_example.sh
	echo "compilation proccess will be done directly in the job"
	exit 
    elif [ $answer = "2" ]; then
        echo "===> Copy test case A"
	export install_dir=$install_dir/TestCaseA
	mkdir -p $install_dir
	mv $install_dir/../specfem3d_globe  $install_dir/.
        cp test_cases/SPECFEM3D_TestCaseA/* $install_dir/specfem3d_globe/DATA/.
	sed -i s/"NEX_XI                          = 384"/"NEX_XI                          = $NEX_XI"/g $install_dir/specfem3d_globe/DATA/Par_file
	sed -i s/"NEX_ETA                         = 384"/"NEX_ETA                          = $NEX_XI"/g $install_dir/specfem3d_globe/DATA/Par_file
	sed -i s/"NPROC_XI                        = 4"/"NPROC_XI                        = $NPROC_XI"/g $install_dir/specfem3d_globe/DATA/Par_file
	sed -i s/"NPROC_ETA                       = 4"/"NPROC_ETA                       = $NPROC_XI"/g $install_dir/specfem3d_globe/DATA/Par_file
    elif [ $answer = "3" ]; then
        echo "===> Copy test case B"
	export install_dir=$install_dir/TestCaseB
	mkdir -p $install_dir
	mv $install_dir/../specfem3d_globe  $install_dir/.
        cp test_cases/SPECFEM3D_TestCaseB/* $install_dir/specfem3d_globe/DATA/.
    fi
    cd $install_dir/specfem3d_globe
    #Clean Configuration
    rm Makefile bin/*
    if [ $machine = "daint-gpu" ] || [ $machine = "davide" ]; then
	echo "Configure for CPU+GPU system"
	### replace `use mpi` if needed ###
	#cd utils
	#perl replace_use_mpi_with_include_mpif_dot_h.pl
	#cd ..
	sed -i s/"GPU_MODE                        = .false."/"GPU_MODE                        = .true."/g  $install_dir/specfem3d_globe/DATA/Par_file
	if [ $machine = "daint-gpu" ];then
		export MPI_INC=$MPICH_DIR/include
		export CUDA_LIB="$CUDATOOLKIT_HOME/lib64"
		export CUDA_INC="$CUDATOOLKIT_HOME/include"
	fi
	./configure --build=ppc64 --with-cuda=cuda5
    elif [ $machine = "vega-gpu" ] || [ $machine = "juwels-booster" ]; then
	echo "Configure for Vega GPU partion or Juwels-booster partition"
	sed -i s/"GPU_MODE                        = .false."/"GPU_MODE                        = .true."/g  $install_dir/specfem3d_globe/DATA/Par_file
	sed -i s/"GPU_DEVICE                      = Tesla"/"GPU_DEVICE                      = *"/g  $install_dir/specfem3d_globe/DATA/Par_file
	./configure --build=ppc64 --with-cuda=cuda8 
    elif [ $machine = "marconi100" ]; then
        echo "Configure for Marconi100 GPU partion"
        sed -i s/"GPU_MODE                        = .false."/"GPU_MODE                        = .true."/g  $install_dir/specfem3d_globe/DATA/Par_file
        sed -i s/"GPU_DEVICE                      = Tesla"/"GPU_DEVICE                      = *"/g  $install_dir/specfem3d_globe/DATA/Par_file
        ./configure --build=ppc64 --with-cuda=cuda8
        sed -i s/"O4"/"O3"/g Makefile #-O4 is not supported with option -qoffload
    else
	echo "Configure for CPU only system"
        ./configure --enable-openmp
    fi
    echo $machine
    #if [ $machine = "occigen" ] || [ $machine = "marenostrum" ] || [ $machine = "marconi-knl" ];then
    #    echo "===> Edit Par_file (MemPerCor=50... )"
    #    sed -i s/"MEMORY_INSTALLED_PER_CORE_IN_GB = 2.5d0"/"MEMORY_INSTALLED_PER_CORE_IN_GB = 50d0"/g DATA/Par_file
    #fi
    echo "===> Build"
    make clean
    time -p make -j 12 all >& make.log &
}

Clean(){
    if [ ! -z "$install_dir" ] && [ -d $install_dir ];then
	    echo "==> Clean installation directory"
	    answer=0
	    while true
            do
                echo "===> Choose Test Case to delete : (1, 2, or 3)"
                echo "1 : Not necessary to delete this folder"
                echo "2 : $install_dir/TestCaseA"
                echo "3 : $install_dir/TestCaseB"
                read answer
                if [[ $answer -eq 1 || $answer -eq 2 || $answer -eq 3 ]]; then break;fi
            done
            if [ $answer = "2" ]; then
                    rm -rf $install_dir/TestCaseA
            elif [ $answer = "3" ]; then
                    rm -rf $install_dir/TestCaseB
            elif [ $answer = "1" ]; then
                    rm -rf $install_dir/specfem3d_globe
            else
		    echo "Nothing has been deleted"
            fi
    else
	    echo "Error with install_dir variable"
	    exit
    fi
}

Deploy(){
    echo "install_dir ="$install_dir
    if [ $machine = "occigen" ] || [ $machine = "marenostrum" ] || [ $machine = "marconi-knl" ] || [ $machine = "daint-cpu-only" ] || [ $machine = "daint-gpu" ]  || [ $machine = "davide" ] || [ $machine = "juwels" ] || [ $machine = "juwels-booster" ] || [ $machine = "irene-skl" ] || [ $machine = "irene-knl" ] || [ $machine = "dibona" ] || [ $machine = "frioul" ]  || [ $machine = "deepsdv" ] || [ $machine = "hazelhen" ] || [ $machine = "vega-cpu" ] || [ $machine = "vega-gpu" ] || [ $machine = "marconi100" ] || [ $machine = "supermuc-ng" ];then
        echo "==> Install on $machine :"
	mkdir -p $install_dir
	Clean
        export ueabs_dir=`pwd`
        Untar
        Install
    else
        echo "machine : $machine "
	echo "Wrong machine !"
        exit
    fi
}

Deploy
