program test_xdr
! test f90 interface to xdr library functions
! Time-stamp: "2000-10-24 10:58:01 cjn"
  use precisn
  use xdr_files
  implicit none
  integer, parameter     :: imax = 5
  integer, parameter     :: jmax = 7
  integer                :: iwrite, iread, iread2
  real(wp)                :: dwrite, dread
  integer                :: imat(jmax), imatr(jmax)
  real(wp)                :: dmat(imax*jmax), dmatr(imax*jmax)
  character(26)          :: string, stringr
  integer                :: i, j, ij, ixdrs
  integer                :: ni, nr, nx

  iwrite = 987654
  dwrite = 1.234567890123456789e0_wp
  string = 'this is an XDR test string'

  ni = digits(iwrite)
  nr = digits(dwrite)
  nx = precision(dwrite)
  write (*,'(a,3i10)') 'digits(i), digits(r), precision(r) = ', ni, &
       nr, nx
  ij = 0
  do j = 1, jmax
     imat(j) = 3 * j**2 + 7
     do i = 1, imax
        ij = ij + 1
        dmat(ij) = real(ij,wp) * 2.0_wp**i
     enddo
  enddo

  write (*,'(a)')  'Original values:'
  write (*,'(a,2i6)')  'imax, jmax = ', imax, jmax
  write (*,'(a,i10,2x,e30.19)') 'iwrite, dwrite = ', iwrite, dwrite
  write (*,'(a,a26)') 'string = ', string
  write (*,'(a,i6,/,(5i10))') 'imat: number of els = ', jmax, imat
  write (*,'(a,i6,/,(3e20.12))') 'dmat: number of els = ', imax*jmax, &
       dmat

! Open the test XDR file
  write (*,'(a)') 'opening test XDR file test.xdr:'
  ixdrs = open_xdr (file='testc.xdr', action= 'write')
  write (*,*) 'opened'

! Write scalar values: integer, real, character
  call xdr_io (ixdrs, iwrite)
  call xdr_io( ixdrs, dwrite )
  call xdr_io (ixdrs, string)

! Write array values: integer, real
  call xdr_io (ixdrs, imat, jmax)
  call xdr_io (ixdrs, dmat, imax*jmax)

  call close_xdr (ixdrs)
  write (*,'(a)') 'test file test.xdr written'
  write (*,'(72("-"))')

  ixdrs = open_xdr ('testc.xdr', 'read')
  call xdr_io (ixdrs, iread)
  call xdr_io (ixdrs, dread)
  call xdr_io (ixdrs, stringr)
  call xdr_io (ixdrs, imatr, 7)
  call xdr_io (ixdrs, dmatr, 35)
  write (*,'(a)')  'Read values:'
  write (*,'(a,i10,2x,e30.19)') 'iread, dread = ', iread, dread
  write (*,'(a,a26)') 'stringr = ', TRIM(stringr)
  write (*,'(a,/,(5i10))') 'imatr: ', imatr
  write (*,'(a,/,(3e20.12))') 'dmatr:', dmatr

  do i = 1, imax*jmax
     if (dmat(i) /= dmatr(i)) then
        write (*,'(i6,a,2e30.19)') i, ' dmat, dmatr = ', dmatr(i), &
             dmatr(i)
     endif
  enddo
! Check rewind:
  write (*,'(a)') 'Rewinding:'
  call rewind_xdr (ixdrs)
  write (*,'(a)') 'Try to reread file:'
  call xdr_io (ixdrs, iread2)
  write (*,'(a,i10)') 'iread2 = ', iread2
  write (*,'(a)') 'Basic checks complete:'
  write (*,'(72("-"))')

  write (*,'(a)') 'Check foreign xdr file:'
  ixdrs = open_xdr ('test.for.xdr', 'read')
  call xdr_io (ixdrs, iread)
  call xdr_io (ixdrs, dread)
  call xdr_io (ixdrs, stringr)
  call xdr_io (ixdrs, imatr, 7)
  call xdr_io (ixdrs, dmatr, 35)
  write (*,'(a)')  'Read values:'
  write (*,'(a,i10,2x,e30.19)') 'iread, dread = ', iread, dread
  write (*,'(a,a26)') 'stringr = ', TRIM(stringr)
  write (*,'(a,/,(5i10))') 'imatr: ', imatr
  write (*,'(a,/,(3e20.12))') 'dmatr:', dmatr

  do i = 1, imax*jmax
     if (dmat(i) /= dmatr(i)) then
        write (*,'(i6,a,2e30.19)') i, ' dmat, dmatr = ', dmatr(i), &
             dmatr(i)
     endif
  enddo
  write (*,'(a)') 'All checks completed:'
  stop
end program test_xdr
