#include <stdio.h>
#include <rpc/rpc.h>
#include "xdrs.h"


extern XDR_element xdrfile[MAX_NUM_XDR_FILES];

#ifdef cray
     XDR_DMAT (int *ixdrid, int *nels, double *d)
#else
void xdr_dmat_(int *ixdrid, int *nels, double *d)
#endif
{
    XDR 	*xdrs;
    u_int	actual_nels, ne;

    xdrs = xdrfile[*ixdrid].xdrs;

    if (xdrs->x_op == XDR_ENCODE) {
	if (*nels < 0) {
	    fprintf (stderr, "XDR real array write error, file %s\n",
		    xdrfile[*ixdrid].filename);
	    fprintf (stderr, "negative number elements specified!\n");
	    exit (-1);
	}
	ne = *nels;
	xdr_array (xdrs, (char **)&d, &ne, *nels, sizeof(double), xdr_double);
    }
    else {
	xdr_array (xdrs, (char **)&d, &actual_nels, *nels, sizeof(double), xdr_double);
	if (actual_nels != *nels) {
	    fprintf (stderr, "XDR read array error, file %s\n",
		     xdrfile[*ixdrid].filename);
	    fprintf (stderr, "%d real elements specified, actually read %d!\n",
		    *nels, actual_nels);
	    exit (-1);
	}
    } 
}
