!===============================================================================
!
! BQCD -- Berlin Quantum ChromoDynamics program
!
! Author: Hinnerk Stueben <stueben@zib.de>
!
! Copyright (C) 1998-2003, Hinnerk Stueben, Zuse-Institut Berlin
!
!-------------------------------------------------------------------------------
!
! clover_action.F90  -  calculates: -2 Tr(log(T_oo))
!
!-------------------------------------------------------------------------------
# include "defs.h"
# include "clover.h"

!-------------------------------------------------------------------------------
REAL function clover_action(b)

  use typedef_clover
  use module_vol
  implicit none

  type(type_clover_b) :: b(2, volh)
  integer             :: i
  REAL                :: s, global_sum
  

  s = ZERO

  !$omp parallel do reduction(+: s)
  do i = 1, volh
     s = s + log(det(b(1, i)) * det(b(2, i)))
  enddo

  clover_action = TWO * global_sum(s)


CONTAINS

  REAL function det(b)  ! returns (1 / det)

    type(type_clover_b) :: b

    det = B11 * B22 * B33 * B44 * B55 * B66

  end function det

end

!===============================================================================
