!===============================================================================
!
! BQCD -- Berlin Quantum ChromoDynamics program
!
! Author: Hinnerk Stueben <stueben@zib.de>
!
! Copyright (C) 1998-2003, Hinnerk Stueben, Zuse-Institut Berlin
!
!-------------------------------------------------------------------------------
!
! clover_t_init.F90 - calculates T
!
!-------------------------------------------------------------------------------
# include "defs.h"

!-------------------------------------------------------------------------------
subroutine clover_t_init(t, b)

  use typedef_clover
  use module_vol
  implicit none

  CLOVER_FIELD_C      :: t
  type(type_clover_b) :: b(2, volh)

  SPINCOL_FIELD  :: x
!dir$ cache_align   x

  integer        :: c1, c2, s1, s2, i

  do c2 = 1, NCOL
     do s2 = 1, NDIRAC

        x = ZERO
        !$omp parallel do
        do i = 1, volh
           x(s2, c2, i) = ONE
        enddo

        call clover_mult_b(b, x, volh)

        !$omp parallel do private(c1, s1)
        do i = 1, volh
           do c1 = 1, NCOL
              do s1 = 1, NDIRAC
                 t(s1, c1, s2, c2, i) = x(s1, c1, i)
              enddo
           enddo
        enddo

     enddo
  enddo
     
end

!===============================================================================
