!===============================================================================
!
! BQCD -- Berlin Quantum ChromoDynamics program
!
! Author: Hinnerk Stueben <stueben@zib.de>
!
! Copyright (C) 1998-2005, Hinnerk Stueben, Zuse-Institut Berlin
!
!-------------------------------------------------------------------------------
!
! comm_shmempi.F90 - MPI + shmem on Altix
!
!-------------------------------------------------------------------------------
# include "defs.h"

!-------------------------------------------------------------------------------
subroutine comm_init()

  implicit none
  include 'mpif.h'
  integer  ierror

  call mpi_init(ierror)
end

!-------------------------------------------------------------------------------
subroutine comm_finalize()

  implicit none
  include 'mpif.h'
  integer  ierror

  call mpi_finalize(ierror)
end

!-------------------------------------------------------------------------------
COMM_METHOD function comm_method()

#ifdef _OPENMP
  comm_method = "shmem/MPI + OpenMP"
#else
  comm_method = "shmem/MPI"
#endif
end

!-------------------------------------------------------------------------------
integer function get_d3_buffer_vol()
  get_d3_buffer_vol = 0
end

!===============================================================================
