!===============================================================================
!
! BQCD -- Berlin Quantum ChromoDynamics program
!
! Author: Hinnerk Stueben <stueben@zib.de>
!
! Copyright (C) 1998-2005, Hinnerk Stueben, Zuse-Institut Berlin
!
!-------------------------------------------------------------------------------
!
! seed_shmem.F90
!
!-------------------------------------------------------------------------------
# include "defs.h"
# include "shmem.h"

!-------------------------------------------------------------------------------
subroutine seed_broadcast(seed)

  use module_function_decl
  implicit none
  include "mpp/shmem.fh"

  SEED          :: seed
  SEED,    save :: s
  integer, save :: psync(SHMEM_BCAST_SYNC_SIZE)

  psync = SHMEM_SYNC_VALUE
  s = seed

  call barrier()
  call shmem_broadcast(s, s, 1, 0, 0, 0, num_pes(), psync)
  call barrier()

  seed = s
end

!-------------------------------------------------------------------------------
subroutine seed_compare(seed)

  use module_function_decl
  implicit none

  SEED       :: seed
  SEED, save :: s
  integer    :: pe

  s = seed
  call barrier()

  if (my_pe() == 0) then
     do pe = 1, num_pes() - 1
        call shmem_get(s, s, 1, pe)
        if (s /= seed) call die('rancheck(): seeds differ')
     enddo
  endif     

  call barrier()
end

!===============================================================================
