!===============================================================================
!
! BQCD -- Berlin Quantum ChromoDynamics program
!
! Author: Hinnerk Stueben <stueben@zib.de>
!
! Copyright (C) 1998-2005, Hinnerk Stueben, Zuse-Institut Berlin
!
!-------------------------------------------------------------------------------
!
! hmc_u.F90  -  U := exp(i * lambda_j * P_j * step) * U
!
!-------------------------------------------------------------------------------
# include "defs.h"

!-------------------------------------------------------------------------------
subroutine hmc_u(p, conf, step, para)

  use typedef_hmc
  use module_switches
  use module_vol
  implicit none

  GENERATOR_FIELD, intent(in)    :: p
  type(hmc_conf),  intent(inout) :: conf
  REAL,            intent(in)    :: step
  type(hmc_para),  intent(in)    :: para

  GENERATOR                      :: q
  SU3                            :: v
  integer                        :: i, mu, eo, j

  TIMING_START(timing_bin_hmc_u)

  do mu = 1, DIM
     do eo = EVEN, ODD
        !$omp parallel do private(j, q, v)
        do i = 1, VOLH
           do j = 1, NGEN
              q(j) = p(j, i, eo, mu) * step
           enddo
           call gen2u(v, q)
           call u_update(conf%u(1, 1, i, eo, mu), v)  ! u = v * u
           call u_normalize(conf%u(1, 1, i, eo, mu))
        enddo
     enddo
  enddo
  
  TIMING_STOP(timing_bin_hmc_u)

  TIMING_START(timing_bin_hmc_xbound_g)
  call xbound_g_field(conf%u)
  TIMING_STOP(timing_bin_hmc_xbound_g)

  if (switches%clover) then
     call clover_init(conf%a, conf%i, conf%b, conf%u, para%csw_kappa)
  endif
end

!===============================================================================
