!===============================================================================
!
! BQCD -- Berlin Quantum ChromoDynamics program
!
! Author: Hinnerk Stueben <stueben@zib.de>
!
! Copyright (C) 2003, Hinnerk Stueben, Zuse-Institut Berlin
!
!-------------------------------------------------------------------------------
!
! module_lattice_io.F90
!
!-------------------------------------------------------------------------------
# include "defs.h"

!-------------------------------------------------------------------------------
module module_lattice_io

  !>> The common block is syntactically identical to 
  !>> module_lattice/common_lattice.  But it contains permutated
  !>> values according to "gamma_index".
  !>> This can be confusing when reading source code !!!!

  ! use a common block, because without, equivalence leads to errors
  ! with Intel Fortran90 compiler 

  integer, dimension(DIM) :: L, N, NH, NPE

  common /common_lattice_io/ L, N, NH, NPE

  integer :: LX, LY, LZ, LT
  integer :: NX, NY, NZ, NT, NXH

  equivalence (L(1), LX)
  equivalence (L(2), LY)
  equivalence (L(3), LZ)
  equivalence (L(4), LT)
  
  equivalence (N(1), NX)
  equivalence (N(2), NY)
  equivalence (N(3), NZ)
  equivalence (N(4), NT)

  equivalence (NH(1), NXH)

end
!===============================================================================
