!===============================================================================
!
! BQCD -- Berlin Quantum ChromoDynamics programme
!
! Author: Hinnerk Stueben <stueben@zib.de>
!
! Copyright (C) 2006, Hinnerk Stueben, Zuse-Institut Berlin
!
!-------------------------------------------------------------------------------
!
! service-bgl.F90 - calls to service routines on BlueGene/L
!
!-------------------------------------------------------------------------------
# include "defs.h"

!-------------------------------------------------------------------------------
subroutine abbruch()

  implicit none
  include 'mpif.h'

  integer ierror

  call mpi_abort(MPI_COMM_WORLD, 1, ierror)
end

!-------------------------------------------------------------------------------
function rechner()  ! returns hostname

  character(len = 20) rechner

  rechner = "jubl"
end

!-------------------------------------------------------------------------------
SECONDS function sekunden()

  integer(8), external :: rts_get_timebase
  real(8), parameter   :: speed = ONE / 700000000.0_8

  sekunden = rts_get_timebase() * speed 
end

!-------------------------------------------------------------------------------
subroutine pxfgetarg(iarg, arg, larg, status)

  implicit none
  integer :: iarg, larg, status
  integer(4) :: i 
  character(len = *) :: arg
  character(len(arg) + 1) :: a

  i = iarg
  call getarg(i, a)

  larg = len_trim(a)
  arg = a
  status = 0
end

!-------------------------------------------------------------------------------
integer function ipxfargc()
  integer(4) :: iargc
  ipxfargc = iargc()
end

!-------------------------------------------------------------------------------
logical function is_big_endian()
  is_big_endian = .true.
end

!===============================================================================
