!===============================================================================
!
! BQCD -- Berlin Quantum ChromoDynamics program
!
! Author: Hinnerk Stueben <stueben@zib.de>
!
! Copyright (C) 2003-2005, Hinnerk Stueben, Zuse-Institut Berlin
!
!-------------------------------------------------------------------------------
!
! w_mult.F90  -  W := M~ + rho (Hasenbusch improvement)
!
!-------------------------------------------------------------------------------
# include "defs.h"
 
!-------------------------------------------------------------------------------
subroutine w_mult(out, in, para, conf)  ! out = W in

  use typedef_hmc
  use module_vol
  implicit none

  type(hmc_para), intent(in)  :: para
  type(hmc_conf), intent(in)  :: conf

  SPINCOL_FIELD,  intent(out) :: out
  SPINCOL_FIELD,  intent(in)  :: in

  call mtil(out, in, para, conf)

  call sc_axpy(out, in, para%rho)

end

!-------------------------------------------------------------------------------
subroutine w_mult_dag(out, in, para, conf)  ! out = W+ in

  use typedef_hmc
  use module_vol
  implicit none

  type(hmc_para), intent(in)  :: para
  type(hmc_conf), intent(in)  :: conf

  SPINCOL_FIELD,  intent(out) :: out
  SPINCOL_FIELD,  intent(in)  :: in

  call mtil_dag(out, in, para, conf)

  call sc_axpy(out, in, para%rho)

end

!-------------------------------------------------------------------------------
subroutine w_dagger_w(out, in, para, conf)  ! out = (W+ W) in

  use typedef_hmc
  use module_p_interface
  use module_vol
  implicit none

  type(hmc_para), intent(in) :: para
  type(hmc_conf), intent(in) :: conf

  SPINCOL_FIELD         :: out, in
  P_SPINCOL_FIELD, save :: tmp   

  TIMING_START(timing_bin_mtdagmt)

  ALLOCATE_SC_FIELD(tmp)

  call w_mult(tmp, in, para, conf)
  call w_mult_dag(out, tmp, para, conf)

  TIMING_STOP(timing_bin_mtdagmt)
end

!===============================================================================
