#include <stdio.h>
#include <rpc/rpc.h>
#include "xdrs.h"

extern XDR_element xdrfile[MAX_NUM_XDR_FILES];

#ifdef cray
     XDR_RMAT64 (int *ixdrid, int *nels, float *r)
#else
void xdr_rmat64_(int *ixdrid, int *nels, float *r)
#endif

{
    XDR 	*xdrs;
    u_int	actual_nels, ne;

    xdrs = xdrfile[*ixdrid].xdrs;

    if (xdrs->x_op == XDR_ENCODE) {
	if (*nels < 0) {
	    fprintf (stderr, "XDR write real64 array error, file %s\n",
		    xdrfile[*ixdrid].filename);
	    fprintf (stderr, "negative number elements specified!\n");
	    exit (-1);
	}
	ne = *nels;
	xdr_array (xdrs, (char **)&r, &ne, ne, 8, xdr_double);
    }
    else {
	ne = *nels;
	xdr_array (xdrs, (char **)&r, &actual_nels, ne, 8, xdr_double);
	if (actual_nels != *nels) {
	    fprintf (stderr, "XDR error, file %s\n",
		     xdrfile[*ixdrid].filename );
	    fprintf (stderr, "%d real64 specified, actually read %d!\n",
		    *nels, actual_nels);
	    exit (-1);
	}
    } 
}
