!===============================================================================
!
! BQCD -- Berlin Quantum ChromoDynamics program
!
! Author: Hinnerk Stueben <stueben@zib.de>
!
! Copyright (C) 1998-2001, Hinnerk Stueben, Zuse Institute Berlin
!
!-------------------------------------------------------------------------------
!
! clover_uuu.F90 - multiplications of three SU(3) matrices
!
!-------------------------------------------------------------------------------
# include "defs.h"

!-------------------------------------------------------------------------------
subroutine clover_uuu_uuu(r, u, v, w)  ! r = u * v * w

  implicit none
  SU3     :: r, u, v, w
  integer :: i, j, k, l

  do i = 1, NCOL
     do l = 1, NCOL
        r(i, l) = ZERO
        do j = 1, NCOL
           do k = 1, NCOL
              r(i, l) = r(i, l) + u(i, j) * v(j, k) * w(k, l)
           enddo
        enddo
     enddo
  enddo

end

!-------------------------------------------------------------------------------
subroutine clover_uuu_duu(r, u, v, w)  ! r = u+ * v * w

  implicit none
  SU3     :: r, u, v, w
  integer :: i, j, k, l

  do i = 1, NCOL
     do l = 1, NCOL
        r(i, l) = ZERO
        do j = 1, NCOL
           do k = 1, NCOL
              r(i, l) = r(i, l) + conjg(u(j, i)) * v(j, k) * w(k, l)
           enddo
        enddo
     enddo
  enddo

end

!-------------------------------------------------------------------------------
subroutine clover_uuu_udu(r, u, v, w)  ! r = u * v+ * w

  implicit none
  SU3     :: r, u, v, w
  integer :: i, j, k, l

  do i = 1, NCOL
     do l = 1, NCOL
        r(i, l) = ZERO
        do j = 1, NCOL
           do k = 1, NCOL
              r(i, l) = r(i, l) + u(i, j) * conjg(v(k, j)) * w(k, l)
           enddo
        enddo
     enddo
  enddo

end

!-------------------------------------------------------------------------------
subroutine clover_uuu_uud(r, u, v, w)  ! r = u * v * w+

  implicit none
  SU3     :: r, u, v, w
  integer :: i, j, k, l

  do i = 1, NCOL
     do l = 1, NCOL
        r(i, l) = ZERO
        do j = 1, NCOL
           do k = 1, NCOL
              r(i, l) = r(i, l) + u(i, j) * v(j, k) * conjg(w(l, k))
           enddo
        enddo
     enddo
  enddo

end

!-------------------------------------------------------------------------------
subroutine clover_uuu_dud(r, u, v, w)  ! r = u+ * v * w+

  implicit none
  SU3     :: r, u, v, w
  integer :: i, j, k, l

  do i = 1, NCOL
     do l = 1, NCOL
        r(i, l) = ZERO
        do j = 1, NCOL
           do k = 1, NCOL
              r(i, l) = r(i, l) + conjg(u(j, i)) * v(j, k) * conjg(w(l, k))
           enddo
        enddo
     enddo
  enddo

end

!===============================================================================
