!===============================================================================
!
! BQCD -- Berlin Quantum ChromoDynamics program
!
! Author: Hinnerk Stueben <stueben@zib.de>
!
! Copyright (C) 2003, Hinnerk Stueben, Zuse-Institut Berlin
!
!-------------------------------------------------------------------------------
!
! typedef_hmc.F90
!
!-------------------------------------------------------------------------------
# include "defs.h"

!-------------------------------------------------------------------------------
module typedef_hmc

  use typedef_clover

  type hmc_para
     REAL :: beta
     REAL :: kappa
     REAL :: csw
     REAL :: csw_kappa
     REAL :: h
     REAL :: traj_length
     REAL :: tau
     REAL :: rho
     integer :: ntau
     integer :: m_scale
     character :: model
  end type hmc_para

  type hmc_para_char
     character(len = 20) :: beta
     character(len = 20) :: kappa
     character(len = 20) :: csw
     character(len = 20) :: csw_kappa
     character(len = 20) :: h
     character(len = 20) :: traj_length
     character(len = 20) :: tau
     character(len = 20) :: ntau
     character(len = 20) :: rho
     character(len = 20) :: m_scale
  end type hmc_para_char

  type hmc_out
     REAL :: exp_dh ! exp(-Delta H)
     REAL :: sg     ! without factor beta
     REAL :: sf
     integer :: accepted
     integer :: cg_ncall
     integer :: cg_niter_max
     integer :: cg_niter_tot
  end type hmc_out

  type hmc_conf
     P_GAUGE_FIELD    :: u
     P_SPINCOL_FIELD  :: phi
     P_SPINCOL_FIELD  :: phi2
     P_CLOVER_FIELD_A :: a       ! A := 1 - kappa c_sw sigma F (in 6x6 blocks)
     P_CLOVER_FIELD_A :: i       ! inverse of A
     P_CLOVER_FIELD_B :: b       ! inverse of A in (L D L+) decomposed form
     integer          :: former  ! ensemble index before tempering
  end type hmc_conf

end
!===============================================================================
