/******************  cs_m_a_vec.c  (in su3.a) ***************************
*									*
*  c_scalar_mult_add_su3vec_KE():						*
*  multiply an su3 vector by a complex scalar and add it to another	*
*  vector:   v1 <- v1 + number*v2 					*
*/
#include "../include/config.h"
#include "../include/complex.h"
#include "../include/su3.h"

void c_scalar_mult_add_su3vec_KE( su3_vector * v1, complex * phase, su3_vector * v2 )
{

#ifndef NATIVEDOUBLE
    register int i;
    complex t;
    for ( i = 0; i < 3; i++ )
    {
	t = cmul_KE( &v2->c[i], phase );
	v1->c[i] = cadd_KE( &v1->c[i], &t );
    }
#else
    register int i;
    register double sr, si, br, bi, cr, ci;

    sr = ( *phase ).real;
    si = ( *phase ).imag;

    for ( i = 0; i < 3; i++ )
    {
	br = v2->c[i].real;
	bi = v2->c[i].imag;

	cr = sr * br - si * bi;
	ci = sr * bi + si * br;

	v1->c[i].real += cr;
	v1->c[i].imag += ci;
    }
#endif
}
