/*******************  trace_su3.c  (in su3.a) ***************************
*									*
* complex trace_su3_KE(a) su3_matrix *a;					*
* return complex trace of an SU3 matrix 				*
*/
#include "../include/config.h"
#include "../include/complex.h"
#include "../include/su3.h"

/* Complex trace of an SU3 matrix */
complex trace_su3_KE( su3_matrix * a )
{
    register complex t1, t2;
    CADD( a->ROWCOL( 0, 0 ), a->ROWCOL( 1, 1 ), t1 );
    CADD( t1, a->ROWCOL( 2, 2 ), t2 );
    return ( t2 );
}
