module slp
! LS quantum numbers
! Time-stamp: "03/07/04 14:33:29 cjn"
  implicit none

  private
  public qno, eq_qno, def_qno, val_qno

  type qno
     integer     lrgl     ! orbital am q. #
     integer     nspn     ! spin multiplicity
     integer     npty     ! parity q. #
  end type qno

  interface operator (==)
     module procedure eq_qno
  end interface

contains

  function eq_qno (q1, q2)
! define equivalence for q # type
    logical               :: eq_qno
    type(qno), intent(in) :: q1
    type(qno), intent(in) :: q2
    eq_qno = .true.
    if (q1%lrgl /= q2%lrgl .or. q1%nspn /= q2%nspn .or. &
         q1%npty /= q2%npty) eq_qno = .false.
  end function eq_qno

  function def_qno (l, s, p)
! define q. # type
    type(qno)              :: def_qno
    integer, intent(in)    :: l   ! orbital am
    integer, intent(in)    :: s   ! spin multiplicity
    integer, intent(in)    :: p   ! parity

    def_qno%lrgl = l
    def_qno%nspn = s
    def_qno%npty = p
  end function def_qno

  function val_qno (q)
! return values of the q. #s in q
    integer                :: val_qno(3)
    type(qno), intent(in)  :: q

    val_qno(1) = q%lrgl
    val_qno(2) = q%nspn
    val_qno(3) = q%npty
  end function val_qno

end module slp
