#include <stdio.h>
#include <rpc/rpc.h>
#include "xdrs.h"


extern XDR_element xdrfile[MAX_NUM_XDR_FILES];

#ifdef cray
     XDR_IMAT (int *ixdrid, int *nels, int *i)
#else
void xdr_imat_(int *ixdrid, int *nels, int *i)
#endif
{
    XDR 	*xdrs;
    u_int	actual_nels, ne;

    xdrs = xdrfile[*ixdrid].xdrs;

    if (xdrs->x_op == XDR_ENCODE) {
	if (*nels < 0) {
	    fprintf (stderr, "XDR int array write error, file %s\n",
		    xdrfile[*ixdrid].filename);
	    fprintf (stderr, "negative number elements specified\n");
	    exit (-1);
	}
	ne = *nels;
	xdr_array (xdrs, (char **)&i, &ne, *nels, sizeof(int), xdr_int);
    }
    else {
	xdr_array (xdrs, (char **)&i, &actual_nels, *nels, sizeof(int), xdr_int);
	if (actual_nels != *nels) {
	    fprintf (stderr, "XDR int array read error, file %s\n",
		     xdrfile[*ixdrid].filename);
	    fprintf (stderr, "%d integers specified, actually read %d\n",
		    *nels, actual_nels);
	    exit (-1);
	}
    } 
}
