!===============================================================================
!
! BQCD -- Berlin Quantum ChromoDynamics program
!
! Author: Hinnerk Stueben <stueben@zib.de>
!
! Copyright (C) 1998-2003, Hinnerk Stueben, Zuse-Institut Berlin
!
!-------------------------------------------------------------------------------
!
! seed_mpi.F90
!
!-------------------------------------------------------------------------------
# include "defs.h"

!-------------------------------------------------------------------------------
subroutine seed_broadcast(seed)

  use module_function_decl
  implicit none
  include 'mpif.h'
  SEED     seed
  integer  ierror

  call mpi_bcast(seed, 1, BQCD_SEED, 0, MPI_COMM_WORLD, ierror)
end  

!-------------------------------------------------------------------------------
subroutine seed_compare(seed)

  use module_function_decl
  implicit none
  include 'mpif.h'  
  SEED     seed, s
  integer  pe, status(MPI_STATUS_SIZE), ierror

  if (my_pe() /= 0) then
     call mpi_ssend(seed, 1, BQCD_SEED, 0, 0, MPI_COMM_WORLD, ierror)
  else
     do pe = 1, num_pes() - 1
        call mpi_recv(s, 1, BQCD_SEED, pe, 0, MPI_COMM_WORLD, status, ierror)
        if (s /= seed) call die('rancheck(): seeds differ')
     enddo
  endif     

end

!===============================================================================
