!===============================================================================
!
! BQCD -- Berlin Quantum ChromoDynamics program
!
! Author: Hinnerk Stueben <stueben@zib.de>
!
! Copyright (C) 1998-2003, Hinnerk Stueben, Zuse-Institut Berlin
!
!-------------------------------------------------------------------------------
!
! hmc_init_p.F90 - initialization of momenta
!
!-------------------------------------------------------------------------------
# include "defs.h"

!-------------------------------------------------------------------------------
subroutine hmc_init_p(p)

  use module_vol
  implicit none

  GENERATOR_FIELD, intent(out) :: p
  integer                      :: mu, eo

  TIMING_START(timing_bin_hmc_init_p)

  do mu = 1, DIM
     do eo = EVEN, ODD
        call ran_gauss_volh(NGEN/2, p(1,1,eo,mu), ONE, eo)
     enddo
  enddo

  TIMING_STOP(timing_bin_hmc_init_p)
end

!===============================================================================
