!===============================================================================
!
! BQCD -- Berlin Quantum ChromoDynamics program
!
! Author: Hinnerk Stueben <stueben@zib.de>
!
! Copyright (C) 2003, Hinnerk Stueben, Zuse-Institut Berlin
!
!-------------------------------------------------------------------------------
!
! module_lattice.F90
!
!-------------------------------------------------------------------------------
# include "defs.h"

!-------------------------------------------------------------------------------
module module_lattice

  !>> See also "module_lattice_io" !!!

  ! use a common block, because without, equivalence leads to errors
  ! with Intel Fortran90 compiler 

  integer, dimension(DIM) :: L, N, NH, NPE

  common /common_lattice/ L, N, NH, NPE

  integer :: LX, LY, LZ, LT
  integer :: NX, NY, NZ, NT, NXH

  equivalence (L(1), LX)
  equivalence (L(2), LY)
  equivalence (L(3), LZ)
  equivalence (L(4), LT)
  
  equivalence (N(1), NX)
  equivalence (N(2), NY)
  equivalence (N(3), NZ)
  equivalence (N(4), NT)

  equivalence (NH(1), NXH)

  integer, dimension(DIM), save :: bc_fermions
  integer, dimension(DIM), save :: gamma_index
  integer, dimension(DIM), save :: decomp_direction

end
!===============================================================================
