!===============================================================================
!
! BQCD -- Berlin Quantum ChromoDynamics program
!
! Author: Hinnerk Stueben <stueben@zib.de>
!
! Copyright (C) 2003, Hinnerk Stueben, Zuse-Institut Berlin
!
!-------------------------------------------------------------------------------
!
! typedef_para.F90
!
!-------------------------------------------------------------------------------
# include "defs.h"

!-------------------------------------------------------------------------------
module typedef_para

   use typedef_hmc

   type type_para

      integer :: run

      integer, dimension(DIM) :: L
      integer, dimension(DIM) :: NPE
      integer, dimension(DIM) :: bc_fermions
      integer, dimension(DIM) :: gamma_index

      integer :: n_temper

      type(hmc_para), dimension(MAX_TEMPER) :: hmc
      type(hmc_para_char), dimension(MAX_TEMPER) :: c_hmc

      integer :: start
      SEED    :: seed
      integer :: swap_seq

      integer :: nforce
      integer :: ntraj
      integer :: nstd
      integer :: maxtraj

      integer :: nsave

      real    :: cg_rest
      integer :: cg_maxiter
      integer :: cg_log

      character(len = 20) c_cg_rest

      FILENAME, dimension(MAX_TEMPER) :: info_file

   end type type_para

end
!===============================================================================
