#!/bin/sh

#################################
## Which version of the code ? ##
#################################

CODE_VERSION=7.0.0
KER_VERSION=${CODE_VERSION}
KERNAME=code_saturne-${KER_VERSION}

################################################
## Installation PATH in the current directory ##
################################################

INSTALLPATH=`pwd`

echo $INSTALLPATH

#####################################
## Environment variables and PATHS ##
#####################################
  
NOM_ARCH=`uname -s`

CS_HOME=${INSTALLPATH}/${KERNAME}

export PATH=$CS_HOME/bin:$PATH

##############
## Cleaning ##
##############

rm -rf $CS_HOME/arch/*
rm -rf $INSTALLPATH/$KERNAME.build

#########################
## Kernel Installation ##
#########################

KERSRC=$INSTALLPATH/$KERNAME
KERBUILD=$INSTALLPATH/$KERNAME.build/arch/$NOM_ARCH
KEROPT=$INSTALLPATH/$KERNAME/arch/$NOM_ARCH

export KEROPT

mkdir -p $KERBUILD
cd $KERBUILD


$KERSRC/configure          \
--disable-shared           \
--disable-nls              \
--without-modules          \
--disable-gui              \
--enable-long-gnum         \
--disable-mei              \
--enable-debug             \
--prefix=$KEROPT           \
CC="mpicc" CFLAGS="-O3" FC="mpif90" FCFLAGS="-O3" CXX="mpicxx" CXXFLAGS="-O3"

make -j 8
make install

cd $INSTALLPATH
