module energy_grid
! Define maximum scattering energy for energy grid region
! Time-stamp: "2003-09-19 13:19:02 cjn"
  use precisn, only: wp
  use io_units, only: fo
  use mpi_params, only: io_processor
  implicit none

  logical, save            :: fine_mesh ! fine/coarse energy grid
  real(wp), save           :: ebig     ! largest scattering energy

  private
  public energy_max
  public fine_mesh, ebig

contains

  subroutine energy_max (imesh, nmesh)
! Define ebig, the maximum scattering energy for case
    use rmx1_in, only:  emax, targ_high_sce, uniform_e_grid, belthr
    use hfile_data, only: ntarg, etarg, tchl, nc
    integer, intent(in)   :: imesh     ! current mesh
    integer, intent(in)   :: nmesh     ! number of energy regions
    real(wp)              :: e1

    if (imesh == 1 .and. nmesh > 1) then ! resonance region (fine mesh)
       fine_mesh = .true.
       e1 = MINVAL(etarg(1:ntarg)) ! ground state energy threshold

       if (targ_high_sce > 0) then ! sequence of final target
          ebig = etarg(targ_high_sce) - e1 - belthr

       else if (uniform_e_grid) then ! end on highest threshold
          ebig = MAXVAL(etarg(1:ntarg)) - e1 - belthr
          
       else ! end on highest theshold for this symmetry
          ebig = MAXVAL(etarg(tchl(1:nc))) - e1 - belthr
       end if

    else ! coarse energy mesh
       fine_mesh = .false.
       ebig = emax
    end if
    if(io_processor) write (fo,'(/a,es12.4,a/)') 'Max. energy, ebig = ', ebig, &
         ' Scaled Rydbergs'
  end subroutine energy_max

end module energy_grid
